/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.unsafe.asm.patch;

import io.gitlab.jfronny.libjf.unsafe.asm.AsmTransformer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.VarInsnNode;

public class PatchUtil {
    public static String mapClassNameInternal(String className) {
        return PatchUtil.mapClassName(className.replace('/', '.')).replace('.', '/');
    }

    public static String mapClassName(String className) {
        return AsmTransformer.MAPPING_RESOLVER.mapClassName("intermediary", className);
    }

    public static String mapMethodName(String owner, String name, String descriptor) {
        return AsmTransformer.MAPPING_RESOLVER.mapMethodName("intermediary", owner, name, descriptor);
    }

    public static String mapDescriptor(String descriptor) {
        return PatchUtil.mapDescriptor(descriptor, 0, descriptor.length());
    }

    public static String mapDescriptor(String desc, int start, int end) {
        int clsStart;
        StringBuilder ret = null;
        int searchStart = start;
        while ((clsStart = desc.indexOf(76, searchStart)) >= 0) {
            int clsEnd = desc.indexOf(59, clsStart + 1);
            if (clsEnd < 0) {
                throw new IllegalArgumentException();
            }
            String cls = desc.substring(clsStart + 1, clsEnd);
            String mappedCls = PatchUtil.mapClassNameInternal(cls);
            if (ret == null) {
                ret = new StringBuilder(end - start);
            }
            ret.append(desc, start, clsStart + 1);
            ret.append(mappedCls);
            start = clsEnd;
            searchStart = clsEnd + 1;
        }
        if (ret == null) {
            return desc.substring(start, end);
        }
        ret.append(desc, start, end);
        return ret.toString();
    }

    public static void redirectReturn(MethodNode method, String targetClass, String hookClass, String targetMethod, String targetType, String ... extraParamTypes) {
        for (AbstractInsnNode node : method.instructions) {
            if (node.getOpcode() != 176 && node.getOpcode() != 172 && node.getOpcode() != 175 && node.getOpcode() != 174 && node.getOpcode() != 173) continue;
            method.instructions.insertBefore(node, PatchUtil.buildParamPassingInvoker(targetClass, hookClass, targetMethod, targetType, targetType, extraParamTypes));
        }
    }

    public static void redirectExceptions(MethodNode method, String targetClass, String hookClass, String exceptionType, String returnTypeNormal, String targetMethod, String ... extraParamTypes) {
        LabelNode start = new LabelNode();
        LabelNode end = new LabelNode();
        LabelNode handler = new LabelNode();
        method.instructions.insertBefore(method.instructions.getFirst(), (AbstractInsnNode)start);
        method.instructions.insertBefore(method.instructions.getLast(), (AbstractInsnNode)end);
        method.instructions.add((AbstractInsnNode)handler);
        method.instructions.add(PatchUtil.buildParamPassingInvoker(targetClass, hookClass, targetMethod, "L" + exceptionType + ";", "L" + returnTypeNormal + ";", extraParamTypes));
        method.instructions.add((AbstractInsnNode)new InsnNode(176));
        method.tryCatchBlocks.add(new TryCatchBlockNode(start, end, handler, exceptionType));
    }

    public static InsnList buildParamPassingInvoker(String targetClass, String hookClass, String targetMethod, String inType, String outType, String ... extraParamTypes) {
        InsnList instructions = new InsnList();
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        StringBuilder descriptor = new StringBuilder("(");
        if (inType != null) {
            descriptor.append(PatchUtil.mapDescriptor(inType));
        }
        descriptor.append('L').append(PatchUtil.mapClassNameInternal(targetClass)).append(';');
        for (int i = 0; i < extraParamTypes.length; ++i) {
            String param;
            instructions.add((AbstractInsnNode)new VarInsnNode(switch (param = extraParamTypes[i]) {
                case "I" -> 21;
                case "D" -> 24;
                case "F" -> 23;
                case "L" -> 22;
                default -> 25;
            }, i + 1));
            while (param.charAt(0) == '[') {
                descriptor.append('[');
                param = param.substring(1);
            }
            if (param.length() == 1) {
                descriptor.append(param);
                continue;
            }
            descriptor.append('L').append(PatchUtil.mapClassNameInternal(param)).append(';');
        }
        descriptor.append(")").append(PatchUtil.mapDescriptor(outType));
        instructions.add((AbstractInsnNode)new MethodInsnNode(184, hookClass, targetMethod, descriptor.toString()));
        return instructions;
    }
}

